﻿
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DAL
{
    internal class Student_CompetencePart : PI.FM.N000.Base.BL.DAL.BaseTable<DBD.Student_CompetencePart, BO.Student_CompetencePart>
    {

        internal Student_CompetencePart(Gemini.Core.BL.Interface.IBusinessLogicPlugIn BusinessLogicPlugIn) : this(BusinessLogicPlugIn.Environment, BusinessLogicPlugIn.DriverName) { }

        internal Student_CompetencePart(Gemini.Core.BL.Interface.DAL.IEnvironment Environment, string DriverName) : base(Environment, DriverName, DBD.Student_CompetencePart.DBD) { }

        internal bool Remove(BO.Student_CompetencePart.Search Search)
        {
            bool _return = false;
            Gemini.Core.BL.Interface.DBD.ICommand _command = InternalExecuteScalar((int)DBD.Student_CompetencePart.Commands.RemoveBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["StudentID"].Value = Search.StudentID;
                Command["CompetenceID"].Value = Search.CompetenceID;
                Command["CompetencePartID"].Value = Search.CompetencePartID;
                Command["IsStarted"].Value = Search.IsStarted;
                Command["IsEnded"].Value = Search.IsEnded;
            });

            if (_command != null)
            {
                if (_command.ResultParam != null)
                {
                    _return = _command.ResultParamValue >= 0 ? true : false;
                }
                else
                {
                    _return = true;
                }
            }
            return _return;
        }

        internal List<BO.Student_CompetencePart> Restore(BO.Student_CompetencePart.Search Search)
        {
            return InternalRestoreList((int)DBD.Student_CompetencePart.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["StudentID"].Value = Search.StudentID;
                Command["CompetenceID"].Value = Search.CompetenceID;
                Command["CompetencePartID"].Value = Search.CompetencePartID;
                Command["IsStarted"].Value = Search.IsStarted;
                Command["IsEnded"].Value = Search.IsEnded;
            });
        }

        internal BO.Student_CompetencePart RestoreTopOne(BO.Student_CompetencePart.Search Search)
        {
            return InternalRestoreOne((int)DBD.Student_CompetencePart.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["StudentID"].Value = Search.StudentID;
                Command["CompetenceID"].Value = Search.CompetenceID;
                Command["CompetencePartID"].Value = Search.CompetencePartID;
                Command["IsStarted"].Value = Search.IsStarted;
                Command["IsEnded"].Value = Search.IsEnded;
            });
        }

        internal int Count(BO.Student_CompetencePart.Search Search)
        {
            Gemini.Core.BL.Interface.DBD.ICommand _command = InternalExecuteScalar((int)DBD.Student_CompetencePart.Commands.CountBySearch,
                delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
                {
                    Command["StudentID"].Value = Search.StudentID;
                    Command["CompetenceID"].Value = Search.CompetenceID;
                    Command["CompetencePartID"].Value = Search.CompetencePartID;
                    Command["IsStarted"].Value = Search.IsStarted;
                    Command["IsEnded"].Value = Search.IsEnded;
                });

            if (_command != null)
            {
                return Convert.ToInt32(_command["Result"].Value);
            }
            return 0;
        }
    }
}
